﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using ConfigSample.Models;
using ConfigSample.Configuration;
using Microsoft.Extensions.Options;

namespace ConfigSample.Controllers
{
    public class HomeController : Controller
    {
        private readonly MySubOptions _options;
        public HomeController(IOptions<MySubOptions> optionsAccessor)
        {
            _options = optionsAccessor.Value;
        }
        public IActionResult Index()
        {
            return View();
        }

        public IActionResult About()
        {
            ViewData["Message"] = _options.Username;

            return View();
        }

        public IActionResult Contact()
        {
            ViewData["Message"] = "Strona z informacjami kontaktowymi.";

            return View();
        }

        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
